import { error } from '@sveltejs/kit';
import {
  PUBLIC_PRODUCTION_API_ORIGIN,
  PUBLIC_DEVELOPMENT_API_ORIGIN
} from '$env/static/public';

// Add invalidation of the load function
/** @type {import('./$types').PageLoad} */
export async function load({ params, fetch, depends }) {
  const apiOrigin = import.meta.env.DEV
    ? PUBLIC_DEVELOPMENT_API_ORIGIN
    : PUBLIC_PRODUCTION_API_ORIGIN;

  try {
    const response = await fetch(
      `${apiOrigin}/post/${params.identifier}/${params.lang}`,
      {
        headers: {
          Accept: 'application/json'
        }
      }
    );

    if (!response.ok) {
      if (response.status === 404) {
        throw error(404, {
          message: 'Post not found'
        });
      }
      throw error(response.status, {
        message: `Error: ${response.statusText}`
      });
    }

    const post = await response.json();

    if (!post) {
      throw error(404, {
        message: 'Post not found'
      });
    }

    return { post };
  } catch (e) {
    console.error('Load error:', e);
    throw error(500, {
      message: 'Error loading post'
    });
  }
}
